
	// Filter PurpleHaze
__kernel void filter_PurpleHaze(__read_only image2d_t image,   		// image image
								__global uchar* tableR,   			// input buffer table R
								__global uchar* tableG,   			// input buffer table G
								__global uchar* tableB,   			// input buffer table B
								__write_only image2d_t retImage,   	// image result
						      __private int alpha)	 				// blend factor, scrope[0-100]	
{
	int w = get_global_id(0);
	int h = get_global_id(1);
	int width = get_image_width(image);
	int height = get_image_height(image);

	if(w >= width || h >= height)
			return;
	const sampler_t sampler = CLK_NORMALIZED_COORDS_FALSE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_NEAREST;
	

	float4 color = read_imagef(image, sampler, (int2)(w, h));
	uchar sr = color.x * 255;
	uchar sg = color.y * 255;
	uchar sb = color.z * 255;
	
	float factor = (float)(alpha)/100.0f;
	
	uchar b = (uchar)(tableB[sb] * factor + (1.0f - factor) * sb);
	uchar g = (uchar)(tableG[sg] * factor + (1.0f - factor) * sg);
	uchar r = (uchar)(tableR[sr] * factor + (1.0f - factor) * sr);
	
	write_imagef(retImage, (int2)(w, h), (float4)(r / 255.0f, g / 255.0f, b / 255.0f, color.w));
}

__kernel void filter_PurpleLomo(__read_only image2d_t image,   		// image image
								__global uchar* tableR,   			// input buffer table R
								__global uchar* tableG,   			// input buffer table G
								__global uchar* tableB,   			// input buffer table B
								__write_only image2d_t retImage,   	// image result
								__private int alpha)	 			// blend factor, scrope[0-100]	
{
	filter_PurpleHaze(image, tableR, tableG, tableB, retImage, alpha);
}

// Filter PurpleHaze

__kernel void filter_PurpleLove(__read_only image2d_t image,   		// image image
								__global uchar* tableR,   			// input buffer table R
								__global uchar* tableG,   			// input buffer table G
								__global uchar* tableB,   			// input buffer table B
								__write_only image2d_t retImage,   	// image result
								__private int alpha)	 			// blend factor, scrope[0-100]	
{
	filter_PurpleHaze(image, tableR, tableG, tableB, retImage, alpha);
}






